/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Objects;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.JetBootsOptions;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketJetBootsActivate;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.JetBootsHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;

public class JetBootsClientHandler
extends IArmorUpgradeClientHandler.SimpleToggleableHandler<JetBootsHandler> {
    private static final ItemStack PICK = new ItemStack((ItemLike)Items.f_42390_);
    private static final ItemStack ROTOR = new ItemStack((ItemLike)ModItems.TURBINE_ROTOR.get());
    private static final ItemStack ELYTRA = new ItemStack((ItemLike)Items.f_42741_);
    private static final ItemStack FEATHER = new ItemStack((ItemLike)Items.f_42402_);
    private static final String[] HEADINGS = new String[]{"S", "SW", "W", "NW", "N", "NE", "E", "SE"};
    public static final ResourceLocation MODULE_BUILDER_MODE = PneumaticRegistry.RL("jet_boots.module.builder_mode");
    public static final ResourceLocation MODULE_FLIGHT_STABILIZERS = PneumaticRegistry.RL("jet_boots.module.flight_stabilizers");
    public static final ResourceLocation MODULE_SMART_HOVER = PneumaticRegistry.RL("jet_boots.module.smart_hover");
    private static final StatPanelLayout DEFAULT_STAT_LAYOUT = new StatPanelLayout(0.5f, 0.005f, false);
    private String l1;
    private String l2;
    private String l3;
    private String r1;
    private String r2;
    private String r3;
    private int widestR;
    private boolean builderMode;
    private boolean flightStabilizers;
    private boolean smartHover;
    private double prevX;
    private double prevY;
    private double prevZ;
    private IGuiAnimatedStat jbStat;

    public JetBootsClientHandler() {
        super(CommonUpgradeHandlers.jetBootsHandler);
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new JetBootsOptions(screen, this);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
        super.tickClient(armorHandler);
        JetBootsHandler jbHandler = CommonUpgradeHandlers.jetBootsHandler;
        JetBootsStateTracker.JetBootsState jbState = jbHandler.getJetBootsSyncedState(armorHandler);
        if (armorHandler.upgradeUsable(jbHandler, false)) {
            if (!(!jbState.isActive() || jbState.isEnabled() && JetBootsClientHandler.thrustKeyPressed(jbState.isBuilderMode()))) {
                NetworkHandler.sendToServer(new PacketJetBootsActivate(false));
                jbHandler.setJetBootsActive(armorHandler, false);
            } else if (!jbState.isActive() && jbState.isEnabled() && JetBootsClientHandler.thrustKeyPressed(jbState.isBuilderMode())) {
                NetworkHandler.sendToServer(new PacketJetBootsActivate(true));
                jbHandler.setJetBootsActive(armorHandler, true);
            }
        }
        String g1 = ChatFormatting.WHITE.toString();
        String g2 = ChatFormatting.GREEN.toString();
        Player player = armorHandler.getPlayer();
        if (this.jbStat.isStatOpen()) {
            double mx = player.m_20185_() - this.prevX;
            double my = player.m_20186_() - this.prevY;
            double mz = player.m_20189_() - this.prevZ;
            this.prevX = player.m_20185_();
            this.prevY = player.m_20186_();
            this.prevZ = player.m_20189_();
            double v = Math.sqrt(mx * mx + my * my + mz * mz);
            double vg = Math.sqrt(mx * mx + mz * mz);
            int heading = Mth.m_14107_((double)((double)(player.m_146908_() * 8.0f / 360.0f) + 0.5)) & 7;
            int yaw = ((int)player.m_146908_() + 180) % 360;
            if (yaw < 0) {
                yaw += 360;
            }
            BlockPos pos = player.m_142538_();
            this.l1 = String.format(" %sSpd: %s%05.2fm/s", g1, g2, v * 20.0);
            this.l2 = String.format("  %sAlt: %s%03dm", g1, g2, pos.m_123342_());
            this.l3 = String.format("%sHead: %s%d\u00b0 (%s)", g1, g2, yaw, HEADINGS[heading]);
            this.r1 = String.format("%sGnd: %s%05.2f", g1, g2, vg * 20.0);
            this.r2 = String.format("%sGnd: %s%dm", g1, g2, pos.m_123342_() - player.f_19853_.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()));
            this.r3 = String.format("%sPch: %s%d\u00b0", g1, g2, (int)(-player.m_146909_()));
            Font fr = Minecraft.m_91087_().f_91062_;
            this.widestR = Math.max(fr.m_92895_(this.r1), Math.max(fr.m_92895_(this.r2), fr.m_92895_(this.r3)));
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer();
            this.builderMode = jbState.isBuilderMode();
            JetBootsHandler.JetBootsLocalState jbLocal = (JetBootsHandler.JetBootsLocalState)handler.getExtensionData(this.getCommonHandler());
            this.flightStabilizers = jbLocal.isFlightStabilizers();
            this.smartHover = jbLocal.isSmartHover();
        }
    }

    @Override
    public void render2D(PoseStack matrixStack, float partialTicks, boolean armorPieceHasPressure) {
        if (armorPieceHasPressure && this.jbStat.isStatOpen()) {
            Font fr = Minecraft.m_91087_().f_91062_;
            int xl = this.jbStat.getBaseX() + 5;
            int n = this.jbStat.getBaseY();
            Objects.requireNonNull(fr);
            int y = n + 9 + 8;
            int xr = this.jbStat.getBaseX() + this.jbStat.getStatWidth() - 5;
            if (this.jbStat.isLeftSided()) {
                xl -= this.jbStat.getStatWidth();
                xr -= this.jbStat.getStatWidth();
            }
            fr.m_92750_(matrixStack, this.l1, (float)xl, (float)y, 0x404040);
            float f = xl;
            Objects.requireNonNull(fr);
            fr.m_92750_(matrixStack, this.l2, f, (float)(y + 9), 0x404040);
            float f2 = xl;
            Objects.requireNonNull(fr);
            fr.m_92750_(matrixStack, this.l3, f2, (float)(y + 9 * 2), 0x404040);
            fr.m_92750_(matrixStack, this.r1, (float)(xr - this.widestR), (float)y, 0x404040);
            float f3 = xr - this.widestR;
            Objects.requireNonNull(fr);
            fr.m_92750_(matrixStack, this.r2, f3, (float)(y + 9), 0x404040);
            float f4 = xr - this.widestR;
            Objects.requireNonNull(fr);
            fr.m_92750_(matrixStack, this.r3, f4, (float)(y + 9 * 2), 0x404040);
            int iconX = xr - 30;
            if (this.builderMode) {
                Minecraft.m_91087_().m_91291_().m_115123_(PICK, iconX, this.jbStat.getBaseY());
                iconX -= 16;
            }
            if (this.flightStabilizers) {
                Minecraft.m_91087_().m_91291_().m_115123_(ROTOR, iconX, this.jbStat.getBaseY());
                iconX -= 16;
            }
            if (ClientUtils.getClientPlayer().m_21255_()) {
                Minecraft.m_91087_().m_91291_().m_115123_(ELYTRA, iconX, this.jbStat.getBaseY());
                iconX -= 16;
            }
            if (this.smartHover) {
                Minecraft.m_91087_().m_91291_().m_115123_(FEATHER, iconX, this.jbStat.getBaseY());
            }
        }
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.jbStat == null) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                this.prevX = player.m_20185_();
                this.prevY = player.m_20186_();
                this.prevZ = player.m_20189_();
            }
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer();
            int n = Math.max(1, handler.getUpgradeCount(EquipmentSlot.FEET, (PNCUpgrade)((Object)ModUpgrades.JET_BOOTS.get())));
            ItemStack stack = new ItemStack((ItemLike)((PNCUpgrade)((Object)ModUpgrades.JET_BOOTS.get())).getItem(n));
            this.jbStat = PneumaticHelmetRegistry.getInstance().makeHUDStatPanel((Component)PneumaticCraftUtils.xlate(IArmorUpgradeHandler.getStringKey(this.getID()), new Object[0]), stack, this);
            this.jbStat.setMinimumContractedDimensions(0, 0);
            this.jbStat.setMinimumExpandedDimensions(120, 42);
        }
        return this.jbStat;
    }

    @Override
    public StatPanelLayout getDefaultStatLayout() {
        return DEFAULT_STAT_LAYOUT;
    }

    @Override
    public void onResolutionChanged() {
        this.jbStat = null;
    }

    @Override
    public Collection<ResourceLocation> getSubKeybinds() {
        return ImmutableList.of((Object)MODULE_BUILDER_MODE, (Object)MODULE_FLIGHT_STABILIZERS, (Object)MODULE_SMART_HOVER);
    }

    private static boolean thrustKeyPressed(boolean builderMode) {
        return KeyHandler.getInstance().keybindJetBoots.m_90857_() || builderMode && Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
    }
}

